<!doctype html>
<html lang="en">

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<title>Elimika Digital</title>
	<meta name="description"
		content="Discover Elimika Digital: Pioneering Education in Tanzania with AI-Powered Learning. Immerse yourself in a world of cutting-edge technology, where AI tailors teaching and assessments for primary and secondary students. Our platform offers interactive, engaging content to ignite curiosity and fuel academic success. Join us for an unparalleled educational experience, blending innovation and personalized learning for a brighter tomorrow. Your journey to excellence starts here!">

	<link rel="icon" href="img/favicon.png">
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<!-- animate CSS -->
	<link rel="stylesheet" href="css/animate.css">
	<!-- owl carousel CSS -->
	<link rel="stylesheet" href="css/owl.carousel.min.css">
	<!-- themify CSS -->
	<link rel="stylesheet" href="css/themify-icons.css">
	<!-- flaticon CSS -->
	<link rel="stylesheet" href="css/flaticon.css">
	<!-- font awesome CSS -->
	<link rel="stylesheet" href="css/magnific-popup.css">
	<!-- swiper CSS -->
	<link rel="stylesheet" href="css/slick.css">
	<!-- style CSS -->
	<link rel="stylesheet" href="css/style.css">
</head>

<body>
	<!--::header part start::-->
	<header class="main_menu home_menu">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-12">
					<nav class="navbar navbar-expand-lg navbar-light">
						<a class="navbar-brand" href="index-2.html"> <img src="img/demo43.png" alt="logo" width="165"
								height="47"> </a>
						<button class="navbar-toggler" type="button" data-toggle="collapse"
							data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
							aria-expanded="false" aria-label="Toggle navigation">
							<span class="navbar-toggler-icon"></span>
						</button>

						<div class="collapse navbar-collapse main-menu-item justify-content-end"
							id="navbarSupportedContent">
							<ul class="navbar-nav align-items-center">
								<li class="nav-item active">
									<a class="nav-link" href="#">Home</a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="#about">About</a>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="#features">Courses</a>
								</li>
								<!-- <li class="nav-item">
									<a class="nav-link" href="blog.html">Blog</a>
								</li>
								<li class="nav-item dropdown">
									<a class="nav-link dropdown-toggle" href="blog.html" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
										Pages
									</a>
									<div class="dropdown-menu" aria-labelledby="navbarDropdown">
										<a class="dropdown-item" href="single-blog.html">Single blog</a>
										<a class="dropdown-item" href="elements.html">Elements</a>
									</div>
								</li>
								<li class="nav-item">
									<a class="nav-link" href="contact.html">Contact</a>
								</li> -->
								<li class="d-none d-lg-block">
									<a class="btn_1" href="login/">LOGIN</a>
								</li>
							</ul>
						</div>
					</nav>
				</div>
			</div>
		</div>
	</header>
	<!-- Header part end-->

	<!-- banner part start-->
	<section class="banner_part" style="background-color: #FCFAFA">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-6 col-xl-6">
					<div class="banner_text">
						<div class="banner_text_iner">
							<h5 class="fw-bold">Embark on an Exhilarating Learning Adventure</h5>
							<!-- <h1>Revolutionize Your Education</h1> -->
							<h1>Experience Education In A Whole New Way</h1>
							<p>Dive into interactive lessons and resources, powered by cutting-edge AI and fun
								educational game technology, tailored for you. Experience excitement and flexibility in
								every learning adventure.</p>
							<a href="login/" class="btn_1">Start Learning</a>
							<!-- <a href="#" class="btn_2">Register </a> -->
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- banner part start-->

	<!-- feature_part start-->
	<section class="feature_part" id="features">
		<div class="container">
			<div class="row">
				<div class="col-sm-6 col-xl-3 align-self-center">
					<div class="single_feature_text">
						<h2>Accessible <br> Learning</h2>
						<p>Comprehensive resources accessible for primary and secondary students.</p>
						<a href="#" class="btn_1">Explore</a>
					</div>
				</div>
				<div class="col-sm-6 col-xl-3">
					<div class="single_feature">
						<div class="single_feature_part">
							<span class="single_feature_icon"><i class="ti-layers"></i></span>
							<h4>Interactive Learning</h4>
							<p>Engaging platforms integrating cutting-edge technologies, including AI, for interactive
								learning experiences.</p>
						</div>
					</div>
				</div>
				<div class="col-sm-6 col-xl-3">
					<div class="single_feature">
						<div class="single_feature_part">
							<span class="single_feature_icon"><i class="ti-new-window"></i></span>
							<h4>Quality Exams</h4>
							<p>Comprehensive and meticulously designed examinations ensuring depth and accuracy in
								assessment.</p>
						</div>
					</div>
				</div>
				<div class="col-sm-6 col-xl-3">
					<div class="single_feature">
						<div class="single_feature_part single_feature_part_2">
							<span class="single_service_icon style_icon"><i class="ti-light-bulb"></i></span>
							<h4>Career Readiness</h4>
							<p>Preparing students for future opportunities with enriched learning experiences.</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- upcoming_event part start-->

	<!-- learning part start-->
	<section class="learning_part" id="about" style="background-color: #fbfcfa">
		<div class="container">
			<div class="row align-items-sm-center align-items-lg-stretch">
				<div class="col-md-7 col-lg-7">
					<div class="learning_img">
						<img src="img/learning_img.png" alt="">
					</div>
				</div>
				<div class="col-md-5 col-lg-5">
					<div class="learning_member_text">
						<h5>About Us</h5>
						<h2>Meticulous Education, Engaging Futures</h2>
						<p>Empowering minds with meticulous and thorough education. We blend professionalism with
							engaging methodologies, fostering forward-thinking individuals.</p>
						<ul>
							<li><span class="ti-pencil-alt"></span>Providing enlightened learning experiences</li>
							<li><span class="ti-ruler-pencil"></span>Nurturing the minds of tomorrow</li>
						</ul>
						<a href="#" class="btn_1">Read More</a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- learning part end-->

	<!-- member_counter counter start -->
	<section class="member_counter">
		<div class="container">
			<div class="row">
				<div class="col-lg-3 col-sm-6">
					<div class="single_member_counter">
						<span class="counter">40</span>
						<h4>All Teachers</h4>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6">
					<div class="single_member_counter">
						<span class="counter">722</span>
						<h4> All Students</h4>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6">
					<div class="single_member_counter">
						<span class="counter">672</span>
						<h4>Online Students</h4>
					</div>
				</div>
				<div class="col-lg-3 col-sm-6">
					<div class="single_member_counter">
						<span class="counter">50</span>
						<h4>Offline Students</h4>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- member_counter counter end -->

	<!--::review_part start::-->
	<section class="special_cource padding_top" hidden>
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-xl-5">
					<div class="section_tittle text-center">
						<p>popular courses</p>
						<h2>Our Army</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-6 col-lg-4">
					<div class="single_special_cource">
						<img src="img/special_cource_1.png" class="special_img" alt="">
						<div class="special_cource_text">
							<a href="course-details.html" class="btn_4">Web Development</a>
							<h4>$130.00</h4>
							<a href="course-details.html">
								<h3>Web Development</h3>
							</a>
							<p>Which whose darkness saying were life unto fish wherein all fish of together called</p>
							<div class="author_info">
								<div class="author_img">
									<img src="img/author/author_1.png" alt="">
									<div class="author_info_text">
										<p>Conduct by:</p>
										<h5><a href="#">James Well</a></h5>
									</div>
								</div>
								<div class="author_rating">
									<div class="rating">
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/star.svg" alt=""></a>
									</div>
									<p>3.8 Ratings</p>
								</div>
							</div>
						</div>

					</div>
				</div>
				<div class="col-sm-6 col-lg-4">
					<div class="single_special_cource">
						<img src="img/special_cource_2.png" class="special_img" alt="">
						<div class="special_cource_text">
							<a href="course-details.html" class="btn_4">design</a>
							<h4>$160.00</h4>
							<a href="course-details.html">
								<h3>Web UX/UI Design </h3>
							</a>
							<p>Which whose darkness saying were life unto fish wherein all fish of together called</p>
							<div class="author_info">
								<div class="author_img">
									<img src="img/author/author_2.png" alt="">
									<div class="author_info_text">
										<p>Conduct by:</p>
										<h5><a href="#">James Well</a></h5>
									</div>
								</div>
								<div class="author_rating">
									<div class="rating">
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/star.svg" alt=""></a>
									</div>
									<p>3.8 Ratings</p>
								</div>
							</div>
						</div>

					</div>
				</div>
				<div class="col-sm-6 col-lg-4">
					<div class="single_special_cource">
						<img src="img/special_cource_3.png" class="special_img" alt="">
						<div class="special_cource_text">
							<a href="course-details.html" class="btn_4">Wordpress</a>
							<h4>$140.00</h4>
							<a href="course-details.html">
								<h3>Wordpress Development</h3>
							</a>
							<p>Which whose darkness saying were life unto fish wherein all fish of together called</p>
							<div class="author_info">
								<div class="author_img">
									<img src="img/author/author_3.png" alt="">
									<div class="author_info_text">
										<p>Conduct by:</p>
										<h5><a href="#">James Well</a></h5>
									</div>
								</div>
								<div class="author_rating">
									<div class="rating">
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/color_star.svg" alt=""></a>
										<a href="#"><img src="img/icon/star.svg" alt=""></a>
									</div>
									<p>3.8 Ratings</p>
								</div>
							</div>
						</div>

					</div>
				</div>
			</div>
		</div>
	</section>
	<!--::blog_part end::-->

	<!-- learning part start-->
	<section class="advance_feature learning_part mt-2">
		<div class="container">
			<div class="row align-items-sm-center align-items-xl-stretch">
				<div class="col-md-6 col-lg-6">
					<div class="learning_member_text">
						<h5>Advance feature</h5>
						<h2>Transforming Education:</h2>
						<h4>Unveiling Our Advanced Educator Learning System</h4>
						<p>Discover our Advanced Educator Learning System, intergrating AI technology and expertise from
							educators to deliver exceptional teaching and examination methods. Tailored for every
							student, our system ensures personalized learning through thorough analysis, meeting
							individual learning needs effortlessly.</p>
						<div class="row">
							<div class="col-sm-6 col-md-12 col-lg-6">
								<div class="learning_member_text_iner">
									<span class="ti-pencil-alt"></span>
									<h4>AI-Powered Learning</h4>
									<p>Experience personalized teaching that adapts to each student's needs
										effortlessly.</p>
								</div>
							</div>
							<div class="col-sm-6 col-md-12 col-lg-6">
								<div class="learning_member_text_iner">
									<span class="ti-stamp"></span>
									<h4>Tailored for you</h4>
									<p>TDiscover how our system tailors learning to fit every student perfectly.</p>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-lg-6 col-md-6">
					<div class="learning_img">
						<img src="img/advance_feature_img.png" alt="">
					</div>
				</div>
			</div>
		</div>
	</section>
	<!-- learning part end-->

	<!--::review_part start::-->
	<section class="testimonial_part" hidden>
		<div class="container-fluid">
			<div class="row justify-content-center">
				<div class="col-xl-5">
					<div class="section_tittle text-center">
						<p>tesimonials</p>
						<h2>Happy Students</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-lg-12">
					<div class="textimonial_iner owl-carousel">
						<div class="testimonial_slider">
							<div class="row">
								<div class="col-lg-8 col-xl-4 col-sm-8 align-self-center">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-lg-4 col-xl-2 col-sm-4">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_1.png" alt="#">
									</div>
								</div>
								<div class="col-xl-4 d-none d-xl-block">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-xl-2 d-none d-xl-block">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_1.png" alt="#">
									</div>
								</div>
							</div>
						</div>
						<div class="testimonial_slider">
							<div class="row">
								<div class="col-lg-8 col-xl-4 col-sm-8 align-self-center">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-lg-4 col-xl-2 col-sm-4">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_2.png" alt="#">
									</div>
								</div>
								<div class="col-xl-4 d-none d-xl-block">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-xl-2 d-none d-xl-block">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_1.png" alt="#">
									</div>
								</div>
							</div>
						</div>
						<div class="testimonial_slider">
							<div class="row">
								<div class="col-lg-8 col-xl-4 col-sm-8 align-self-center">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-lg-4 col-xl-2 col-sm-4">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_3.png" alt="#">
									</div>
								</div>
								<div class="col-xl-4 d-none d-xl-block">
									<div class="testimonial_slider_text">
										<p>Behold place was a multiply creeping creature his domin to thiren open void
											hath herb divided divide creepeth living shall i call beginning
											third sea itself set</p>
										<h4>Michel Hashale</h4>
										<h5> Sr. Web designer</h5>
									</div>
								</div>
								<div class="col-xl-2 d-none d-xl-block">
									<div class="testimonial_slider_img">
										<img src="img/testimonial_img_1.png" alt="#">
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
		</div>
	</section>
	<!--::blog_part end::-->

	<!--::blog_part start::-->
	<section class="blog_part section_padding" hidden>
		<div class="container">
			<div class="row justify-content-center">
				<div class="col-xl-5">
					<div class="section_tittle text-center">
						<p>Our Blog</p>
						<h2>Students Blog</h2>
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-sm-6 col-lg-4 col-xl-4">
					<div class="single-home-blog">
						<div class="card">
							<img src="img/blog/blog_1.png" class="card-img-top" alt="blog">
							<div class="card-body">
								<a href="#" class="btn_4">Design</a>
								<a href="blog.html">
									<h5 class="card-title">Dry beginning sea over tree</h5>
								</a>
								<p>Which whose darkness saying were life unto fish wherein all fish of together called
								</p>
								<ul>
									<li> <span class="ti-comments"></span>2 Comments</li>
									<li> <span class="ti-heart"></span>2k Like</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-6 col-lg-4 col-xl-4">
					<div class="single-home-blog">
						<div class="card">
							<img src="img/blog/blog_2.png" class="card-img-top" alt="blog">
							<div class="card-body">
								<a href="#" class="btn_4">Developing</a>
								<a href="blog.html">
									<h5 class="card-title">All beginning air two likeness</h5>
								</a>
								<p>Which whose darkness saying were life unto fish wherein all fish of together called
								</p>
								<ul>
									<li> <span class="ti-comments"></span>2 Comments</li>
									<li> <span class="ti-heart"></span>2k Like</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-6 col-lg-4 col-xl-4">
					<div class="single-home-blog">
						<div class="card">
							<img src="img/blog/blog_3.png" class="card-img-top" alt="blog">
							<div class="card-body">
								<a href="#" class="btn_4">Design</a>
								<a href="blog.html">
									<h5 class="card-title">Form day seasons sea hand</h5>
								</a>
								<p>Which whose darkness saying were life unto fish wherein all fish of together called
								</p>
								<ul>
									<li> <span class="ti-comments"></span>2 Comments</li>
									<li> <span class="ti-heart"></span>2k Like</li>
								</ul>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--::blog_part end::-->

	<!-- footer part start-->
	<footer class="footer-area">
		<div class="container">
			<div class="row justify-content-between">
				<div class="col-sm-6 col-md-4 col-xl-3">
					<div class="single-footer-widget footer_1">
						<a href="#"> <img src="img/demo43 ico.png" alt=""> </a>
						<p>Redefining education at Elimika Digital! Elevate learning with our dynamic online platform.
							Engaging, tech-powered courses offer a personalized journey.</p>
						<p>Join us for academic success!</p>
					</div>
				</div>
				<div class="col-sm-6 col-md-4 col-xl-4">
					<div class="single-footer-widget footer_2">
						<h4>Newsletter</h4>
						<p>Stay updated with our latest trends Seed heaven so said place winged over given forth fruit.
						</p>
						<form action="#">
							<div class="form-group">
								<div class="input-group mb-3">
									<input type="text" class="form-control" placeholder='Enter email address'
										onfocus="this.placeholder = ''"
										onblur="this.placeholder = 'Enter email address'">
									<div class="input-group-append">
										<button class="btn btn_1" type="button"><i class="ti-angle-right"></i></button>
									</div>
								</div>
							</div>
						</form>
						<div class="social_icon">
							<a href="#"> <i class="ti-facebook"></i> </a>
							<a href="#"> <i class="ti-twitter-alt"></i> </a>
							<a href="#"> <i class="ti-instagram"></i> </a>
							<a href="#"> <i class="ti-skype"></i> </a>
						</div>
					</div>
				</div>
				<div class="col-xl-3 col-sm-6 col-md-4">
					<div class="single-footer-widget footer_2">
						<h4>Contact us</h4>
						<div class="contact_info">
							<p><span> Address :</span> Kinondoni, Dar Es Salaam </p>
							<p><span> Phone :</span> <a class="nodeco" href="tel:+255716977008">+255 716 977 008</a></p>
							<p><span> Email : </span><a class="nodeco"
									href="emailTo:info@elimikadigital.co.tz">info@elimikadigital.co.tz</a> </p>
						</div>
					</div>
				</div>
			</div>

		</div>
		<div class="container-fluid">
			<div class="row">
				<div class="col-lg-12">
					<div class="copyright_part_text text-center">
						<div class="row">
							<div class="col-lg-12">
								<p class="footer-text m-0">
									Copyright &copy;
									<script>document.write(new Date().getFullYear());</script> All rights reserved
									<!--  | This template is made with <i class="ti-heart" aria-hidden="true"></i> by <a href="https://colorlib.com/" target="_blank">Colorlib</a> -->
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>
	<!-- footer part end-->

	<!-- jquery plugins here-->
	<!-- jquery -->
	<script src="js/jquery-1.12.1.min.js"></script>
	<!-- popper js -->
	<script src="js/popper.min.js"></script>
	<!-- bootstrap js -->
	<script src="js/bootstrap.min.js"></script>
	<!-- easing js -->
	<script src="js/jquery.magnific-popup.js"></script>
	<!-- swiper js -->
	<script src="js/swiper.min.js"></script>
	<!-- swiper js -->
	<script src="js/masonry.pkgd.js"></script>
	<!-- particles js -->
	<script src="js/owl.carousel.min.js"></script>
	<script src="js/jquery.nice-select.min.js"></script>
	<!-- swiper js -->
	<script src="js/slick.min.js"></script>
	<script src="js/jquery.counterup.min.js"></script>
	<script src="js/waypoints.min.js"></script>
	<!-- custom js -->
	<script src="js/custom.js"></script>
</body>

</html>