<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>Login Page</title>
	<link rel="icon" href="../img/favicon.png">
	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="../css/bootstrap.min.css">
	<!-- animate CSS -->
	<link rel="stylesheet" href="../css/animate.css">
	<!-- owl carousel CSS -->
	<link rel="stylesheet" href="../css/owl.carousel.min.css">
	<!-- themify CSS -->
	<link rel="stylesheet" href="../css/themify-icons.css">
	<!-- flaticon CSS -->
	<link rel="stylesheet" href="../css/flaticon.css">
	<!-- font awesome CSS -->
	<link rel="stylesheet" href="../css/magnific-popup.css">
	<!-- swiper CSS -->
	<link rel="stylesheet" href="../css/slick.css">
	<!-- style CSS -->
	<link rel="stylesheet" href="../css/style.css">
	<!-- style CSS -->
	<link rel="stylesheet" href="../css/style.css">
	<style>
		body {
			background-color: #f8f9fa;
			position: relative;
			min-height: 100vh;
		}
		.card {
			border: none;
			border-radius: 10px;
			box-shadow: 0px 0px 20px 0px rgba(0,0,0,0.1);
		}
		.card-img-top {
			border-radius: 10px 0 0 10px;
			height: 100%;
			object-fit: cover;
		}
		.card-body {
			padding: 40px;
		}
		.btn-primary {
			background-color: #007bff;
			border: none;
		}
		.btn-primary:hover {
			background-color: #0056b3;
		}
		.forgot-password {
			color: #007bff;
			text-decoration: none;
		}
		.forgot-password:hover {
			text-decoration: underline;
		}
		footer {
			background-color: #f8f9fa;
			text-align: center;
			padding: 10px 0;
			position: absolute;
			bottom: 0;
			width: 100%;
		}
	</style>
</head>
<body>

<div class="container mt-5">
	<div class="row">
		<!-- First column for login interface -->
		<div class="col-md-6">
			<div class="card">
				<div class="card-body" id="login">
					<h2 class="card-title text-center mb-4">Login</h2>
					<form method="POST" action="../control/ajax_action.php">
						<div class="form-group">
							<label for="username">Username</label>
							<input type="text" class="form-control" id="username" placeholder="Enter your username">
						</div>
						<div class="form-group">
							<label for="password">Password</label>
							<input type="password" class="form-control" id="password" placeholder="Enter your password">
						</div>
						<div class="text-right mt-3">
							<a href="#" class="forgot-password">Forgot Password?</a>
						</div>
						<button type="submit" class="btn_1 btn-block mt-4">Login</button>
						<div class="text-center mt-3">
							<p>Are you new here? <a href="../register" id="registerHr">Register here</a></p>
						</div>
					</form>
				</div>
			</div>
		</div>

		<!-- Second column for picture -->
		<div class="col-md-6">
			<div class="card" style="background-image: linear-gradient(to left, #ee390f 0%, #f9b700 51%, #ee390f 100%);">
				<div class="card-body">
					<img src="../img/dark.png" class="card-img-top" alt="Login Image">
				</div>
			</div>
		</div>
	</div>
</div>

<footer class="footer mt-5">
	<div class="container">
		<p>&copy; <span id="year"></span> Elimika Digital. All Rights Reserved.</p>
	</div>
</footer>

<script>
	const yearSpan = document.getElementById('year');
	const currentYear = new Date().getFullYear();
	yearSpan.textContent = currentYear;
</script>



<!-- jquery plugins here-->
<!-- jquery -->
<script src="../js/jquery-1.12.1.min.js"></script>
<!-- popper js -->
<script src="../js/popper.min.js"></script>
<!-- bootstrap js -->
<script src="../js/bootstrap.min.js"></script>
<!-- easing js -->
<script src="../js/jquery.magnific-popup.js"></script>
<!-- swiper js -->
<script src="../js/swiper.min.js"></script>
<!-- swiper js -->
<script src="../js/masonry.pkgd.js"></script>
<!-- particles js -->
<script src="../js/owl.carousel.min.js"></script>
<script src="../js/jquery.nice-select.min.js"></script>
<!-- swiper js -->
<script src="../js/slick.min.js"></script>
<script src="../js/jquery.counterup.min.js"></script>
<script src="../js/waypoints.min.js"></script>
<!-- custom js -->
<script src="../js/custom.js"></script>
<script src="../js/elimika.js"></script>

</body>
</html>